/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheAccess;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheHandleQ;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.NoObjectAvailableException;
import oracle.ias.cache.NotAPoolException;
import oracle.ias.cache.NullObjectNameException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.ias.cache.PoolInstanceFactory;
import oracle.ias.cache.PoolLoader;
import oracle.ias.cache.PoolMgr;

public class PoolAccess {
    private static final String POOL_OBJECT_NAME = "$$POOL_OBJECT";
    private static final String POOL_LOADER_NAME = "$$POOL_LOADER$$";
    private CacheHandle poolHandle = null;
    private String region = null;
    private String name = null;
    private PoolMgr poolMgr = null;
    private int objectIndex = -1;
    private boolean hasAffinity = false;
    private int affinityVersion = 0;

    private PoolAccess(String string, String string2) throws NotAPoolException, CacheException {
        if (string == null || string2 == null) {
            throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
        }
        this.region = string;
        this.name = string2;
        this.getHandle();
        if (this.poolMgr == null) {
            if (this.poolHandle != null) {
                CacheHandleQ.releaseHandle(this.poolHandle);
            }
            throw PoolAccess.exceptionHandler("PoolAccess.PoolAccess", new NotAPoolException(CacheInternal.EXP_NOTPOOL + ": \"" + string2 + "\""));
        }
        this.hasAffinity = this.poolMgr.hasAffinity();
    }

    private void getHandle() throws CacheException {
        try {
            this.poolHandle = CacheHandleQ.getHandle();
            this.poolHandle.findGroup(this.name, this.region, null);
            this.poolMgr = this.poolHandle.getPoolMgr();
        }
        catch (Exception exception) {
            if (this.poolHandle != null) {
                CacheHandleQ.releaseHandle(this.poolHandle);
            }
            throw PoolAccess.exceptionHandler("PoolAccess.PoolAccess", exception);
        }
    }

    private static CacheException exceptionHandler(String string, Exception exception) {
        return CacheInternal.exceptionHandler(CacheInternal.EXP_EXCEPTIONIN + " " + string, exception);
    }

    public static PoolAccess getPool(String string) throws NotAPoolException, ObjectNotFoundException, CacheException {
        return PoolAccess.getPool(CacheAccess.getDefRegionName(), string);
    }

    public static PoolAccess getPool(String string, String string2) throws NotAPoolException, ObjectNotFoundException, CacheException {
        return new PoolAccess(string, string2);
    }

    public void close() throws CacheException {
        if (this.poolHandle != null) {
            CacheHandleQ.releaseHandle(this.poolHandle);
        }
        this.poolHandle = null;
        this.objectIndex = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void createPool(String string, String string2, String string3, PoolInstanceFactory poolInstanceFactory, Attributes attributes, int n, int n2) throws InvalidArgumentException, CacheException {
        CacheHandle cacheHandle = null;
        try {
            if (n < 0 || n2 < 1 || n2 < n) {
                throw new InvalidArgumentException(CacheInternal.EXP_INVALARG + ": min, max");
            }
            if (string == null || string2 == null || string3 == null) {
                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
            }
            cacheHandle = CacheHandleQ.getHandle();
            if (attributes == null) {
                attributes = new Attributes();
            }
            long l = attributes.getFlags();
            attributes.setFlags(l | 0x10L);
            PoolMgr poolMgr = new PoolMgr(poolInstanceFactory, attributes, n, n2);
            attributes.setLoader(new PoolLoader(poolMgr));
            cacheHandle.createGroup(string3, string, null, string2, attributes);
            cacheHandle.setPoolMgr(poolMgr);
            for (int i = 0; i < n; ++i) {
                cacheHandle.locateObject(string3 + POOL_OBJECT_NAME + i, string, string3, new Integer(i));
            }
            if (cacheHandle == null) return;
        }
        catch (Exception exception) {
            try {
                throw PoolAccess.exceptionHandler("PoolAccess.createPool", exception);
            }
            catch (Throwable throwable) {
                if (cacheHandle == null) throw throwable;
                CacheHandleQ.releaseHandle(cacheHandle);
                throw throwable;
            }
        }
        CacheHandleQ.releaseHandle(cacheHandle);
        return;
    }

    public Object get() throws NoObjectAvailableException, CacheException {
        if (this.objectIndex != -1 && this.hasAffinity) {
            this.poolHandle = this.poolMgr.getAffinity(this.objectIndex, this.affinityVersion);
            if (this.poolHandle != null) {
                return this.poolHandle.getObject();
            }
            this.objectIndex = -1;
            this.getHandle();
        }
        if (this.objectIndex == -1) {
            this.objectIndex = this.poolMgr.getIndex();
            if (this.objectIndex == -1) {
                throw PoolAccess.exceptionHandler("PoolAccess.get", new NoObjectAvailableException(CacheInternal.EXP_POOLEMPTY + " \"" + this.name + "\""));
            }
        }
        Object object = null;
        try {
            object = this.poolHandle.locateObject(this.name + POOL_OBJECT_NAME + this.objectIndex, this.region, this.name, new Integer(this.objectIndex));
        }
        catch (Exception exception) {
            throw PoolAccess.exceptionHandler("PoolAccess.get", exception);
        }
        return object;
    }

    public void returnToPool() {
        if (this.hasAffinity) {
            this.affinityVersion = this.poolMgr.releaseAffinity(this.objectIndex, this.poolHandle);
            this.poolHandle = null;
        } else {
            if (this.objectIndex == -1) {
                return;
            }
            this.poolMgr.releaseIndex(this.objectIndex);
            this.objectIndex = -1;
            try {
                CacheHandleQ.releaseHandle(this.poolHandle);
            }
            catch (CacheException cacheException) {
                CacheInternal.exceptionLog("[Mem] ", cacheException);
            }
        }
    }

    public void release() {
        if (this.objectIndex != -1 && this.hasAffinity) {
            this.poolHandle = this.poolMgr.getAffinity(this.objectIndex, this.affinityVersion);
            if (this.poolHandle == null) {
                this.objectIndex = -1;
            }
        }
        if (this.objectIndex == -1) {
            return;
        }
        this.poolMgr.releaseIndex(this.objectIndex);
        this.objectIndex = -1;
        try {
            CacheHandleQ.releaseHandle(this.poolHandle);
        }
        catch (CacheException cacheException) {
            CacheInternal.exceptionLog("[Mem] ", cacheException);
        }
    }

    public String toString() {
        return this.region + "::" + this.name + "::" + this.objectIndex + "::" + this.poolMgr.toString();
    }
}

